package gov.va.vamf.scheduling.direct.exception;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class BasicValidationExceptionMapper implements ExceptionMapper<BasicValidationException> {

    @Override
    public Response toResponse(BasicValidationException ex) {
        return Response.status(Response.Status.BAD_REQUEST).entity(ex.getErrors()).type(MediaType.APPLICATION_JSON).build();
    }
}
